using System;
using Server;
using Server.Gumps;
using Server.Network;
using System.Collections;
using Server.Items;
using Server.Misc;

namespace Server.Items
{
	[FlipableAttribute( 6773, 14089 )]
	public class QuestEssence : Item
	{
		public enum Dungeony
		{
			Covetous, Deceit, Despise, Destard, Hythloth,
			Shame, Wrong, Fire, Ice, Khaldun, Toxic, Mages
		}
		
		private Dungeony c_Dung;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public Dungeony Dung { get { return c_Dung; } set { c_Dung = value; } }
		
		[Constructable]
		public QuestEssence() : base( 14089 )
		{
			Weight = 1.0;
			Movable = false;
			Name = "Vytrysk energie";
			Hue = 1097;
			Light = LightType.Circle300;
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			QuestJar questjar = from.Backpack.FindItemByType( typeof( QuestJar ) ) as QuestJar;
			
			if ( !from.InRange( this.GetWorldLocation(), 2 ) )
				from.SendLocalizedMessage( 502138 );
			else if ( questjar != null )
			{
				if ( questjar.isFull == true || questjar.Owner != from )
					from.SendMessage("Nic se nedeje");
				else
				{
					bool added = false;
					switch ( c_Dung )
					{
						case Dungeony.Covetous:
							{
								if ( questjar.Covetous == false )
								{
									questjar.Covetous = true;
									added = true;
								}
								break;
							}
						case Dungeony.Deceit:
							{
								if ( questjar.Deceit == false )
								{
									questjar.Deceit = true;
									added = true;
								}
								break;
							}
						case Dungeony.Despise:
							{
								if ( questjar.Despise == false )
								{
									questjar.Despise = true;
									added = true;
								}
								break;
							}
						case Dungeony.Destard:
							{
								if ( questjar.Destard == false )
								{
									questjar.Destard = true;
									added = true;
								}
								break;
							}
						case Dungeony.Hythloth:
							{
								if ( questjar.Hythloth == false )
								{
									questjar.Hythloth = true;
									added = true;
								}
								break;
							}
						case Dungeony.Shame:
							{
								if ( questjar.Shame == false )
								{
									questjar.Shame = true;
									added = true;
								}
								break;
							}
						case Dungeony.Wrong:
							{
								if ( questjar.Wrong == false )
								{
									questjar.Wrong = true;
									added = true;
								}
								break;
							}
						case Dungeony.Fire:
							{
								if ( questjar.Fire == false )
								{
									questjar.Fire = true;
									added = true;
								}
								break;
							}
						case Dungeony.Ice:
							{
								if ( questjar.Ice == false )
								{
									questjar.Ice = true;
									added = true;
								}
								break;
							}
						case Dungeony.Khaldun:
							{
								if ( questjar.Khaldun == false )
								{
									questjar.Khaldun = true;
									added = true;
								}
								break;
							}
						case Dungeony.Toxic:
							{
								if ( questjar.Toxic == false )
								{
									questjar.Toxic = true;
									added = true;
								}
								break;
							}
						case Dungeony.Mages:
							{
								if ( questjar.Mages == false )
								{
									questjar.Mages = true;
									added = true;
								}
								break;
							}
					}
					
					if ( added == true )
					{
						from.SendMessage(66, "Energie byla zachycena do nadobky v tvem batohu!");
						from.SendGump( new QuestJarGump( from, questjar ) );
						from.FixedParticles( 0x376A, 9, 32, 5007, EffectLayer.Waist );
						Effects.PlaySound( from.Location, from.Map, 0x1E3 );
						
						if (questjar.Covetous && questjar.Deceit && questjar.Despise && questjar.Destard && questjar.Hythloth && questjar.Shame && questjar.Wrong && questjar.Fire && questjar.Ice && questjar.Khaldun && questjar.Toxic && questjar.Mages )
						{
							questjar.isFull = true;
							questjar.ItemID = 4102;
							questjar.Hue = 43;
						}
					}
					else
						from.SendMessage("Tento druh energie je jiz v nadobce v tvem batohu obsazen.");
				}
			}
			else
				from.SendMessage("Nic se nedeje...");
		}

		public QuestEssence( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
			
			writer.Write( (int) c_Dung);
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();

			c_Dung = (Dungeony)reader.ReadInt();
		}
	}
}
